from datetime import timedelta

import constance
from django.utils import timezone

from idm.core.constants.action import ACTION
from idm.core.models import Action

from idm.monitorings.answer import CritAnswer
from idm.monitorings.views.base import BaseMonitoringView


class IdmErrorCount(BaseMonitoringView):

    def monitoring(self):
        now = timezone.now()
        count = Action.objects.filter(
            action=ACTION.IDM_ERROR,
            added__gt=now - timedelta(hours=constance.config.IDM_ERROR_WINDOW_HOURS)
        ).count()
        if count > constance.config.IDM_ERROR_COUNT_THRESHOLD:
            return CritAnswer(f"IDM has {count} actions `{ACTION.IDM_ERROR}` "
                              f"in last {constance.config.IDM_ERROR_WINDOW_HOURS} hours")
        return None
