# coding: utf-8
from django.conf import settings

from idm.monitorings.metric import PassportLoginsToSubscribeMetric
from idm.monitorings.views.base import BaseCachedMonitoring


class PassportLoginsToSubscribe(BaseCachedMonitoring):
    cached_metric = PassportLoginsToSubscribeMetric

    def get_errors_from_cached_value(self, cached_value: int):
        if cached_value > settings.IDM_SID67_THRESHOLD:
            return ['IDM has {} passport logins to subscribe'.format(cached_value)]

        return []
