# coding: utf-8


import constance
from django.utils import timezone

from idm.monitorings.views.base import BaseMonitoringView
from idm.users.models import User


class AdBlockedUsersView(BaseMonitoringView):
    def monitoring(self):
        flap_time = timezone.now() - timezone.timedelta(hours=int(constance.config.FIRED_BUT_ACTIVE_IN_AD_TIMEDELTA))
        users = (
            User.objects
                .dismissed()
                .filter(idm_found_out_dismissal__lt=flap_time)
                .exclude(ldap_active=False)
                .values_list('username', flat=True)
        )

        if users:
            return ['IDM has {} fired, but active in AD users: {}'.format(users.count(), ', '.join(users))]
        return []
