# coding: utf-8
from __future__ import absolute_import

from django.utils import timezone

from idm.core.models import SystemRolePush
from idm.monitorings.views.base import BaseMonitoringView


class SystemRolePushView(BaseMonitoringView):
    THRESHOLD = timezone.timedelta(minutes=30)

    def monitoring(self):
        pushes = set(SystemRolePush.objects.filter(
            system__added__lt=timezone.now() - self.THRESHOLD
        ).values_list('system__slug', flat=True))

        if pushes:
            return ['IDM has {} systems with not pushed responsibles or team members: {}'.format(
                len(pushes), ', '.join(pushes)
            )]
