# coding: utf-8

from idm.monitorings.metric import OverlengthedRefRoleChainMetric
from idm.monitorings.views.base import BaseCachedMonitoring


class OverlengthedRefRolesChain(BaseCachedMonitoring):
    cached_metric = OverlengthedRefRoleChainMetric

    def get_errors_from_cached_value(self, cached_value):
        errors = []
        if cached_value:
            errors.append(f'''Roles with overlengthed refs chain: {', '.join(
                [str(pk) for pk in cached_value]
            )}''')

        return errors
