import json

from idm.monitorings.metric import ReviewRolesThresholdExceededMetric
from idm.monitorings.views.base import BaseCachedMonitoring


class ReviewRolesThresholdExceeded(BaseCachedMonitoring):
    cached_metric = ReviewRolesThresholdExceededMetric

    def get_errors_from_cached_value(self, cached_value):
        errors = []
        if cached_value:
            data = json.dumps(cached_value)
            errors.append(f'Number of roles to review on last run: {data}')
        return errors
