# coding: utf-8


import constance

from django.db.models import Q
from django.utils import timezone

from idm.monitorings.views.base import BaseMonitoringView
from idm.users.models import User, GroupMembership


class UsersWithoutDepartmentGroupView(BaseMonitoringView):
    def monitoring(self):

        flap_time = timezone.now() - timezone.timedelta(hours=int(constance.config.USERS_WITHOUT_DEPARTMENT_TIMEDELTA))
        group_type_filter = Q(group__type='department')
        active_membership_state_filter = Q(state='active') | Q(date_leaved__gt=flap_time)
        exclude_query = group_type_filter & active_membership_state_filter

        users_with_department_groups = GroupMembership.objects.filter(exclude_query).values_list('user', flat=True)

        users = (
            User.objects
            .users()
            .filter(is_active=True)
            .exclude(pk__in=users_with_department_groups)
            .exclude(username='AnonymousUser')
            .values_list('username', flat=True)
        )

        count = users.count()
        if count:
            return ['IDM has {} users without department group: {}'.format(count, ', '.join(users))]

        return []
