# coding: utf-8


import logging
from collections import defaultdict

from django.conf import settings
from django.utils.functional import cached_property
from ids.registry import registry

log = logging.getLogger(__name__)


class IDSFetcher(object):

    def __init__(self, page_size=settings.IDM_IDS_PAGE_SIZE):
        self.page_size = page_size

    @cached_property
    def staff_groups_repo(self):
        return registry.get_repository(
            'staff', 'group',
            oauth_token=settings.IDM_STAFF_OAUTH_TOKEN,
            user_agent=settings.IDM_IDS_USER_AGENT,
            timeout=settings.IDM_IDS_TIMEOUT
        )

    @cached_property
    def staff_memberships_repo(self):
        return registry.get_repository(
            'staff', 'groupmembership',
            oauth_token=settings.IDM_STAFF_OAUTH_TOKEN,
            user_agent=settings.IDM_IDS_USER_AGENT,
            timeout=settings.IDM_IDS_TIMEOUT
        )

    @cached_property
    def abc_services_repo(self):
        return registry.get_repository(
            'abc', 'service',
            oauth_token=settings.IDM_PLANNER_OAUTH_TOKEN,
            user_agent=settings.IDM_IDS_USER_AGENT,
            timeout=settings.IDM_IDS_TIMEOUT
        )

    @cached_property
    def abc_members_repo(self):
        return registry.get_repository(
            'abc', 'service_members',
            oauth_token=settings.IDM_PLANNER_OAUTH_TOKEN,
            user_agent=settings.IDM_IDS_USER_AGENT,
            timeout=settings.IDM_IDS_TIMEOUT
        )

    def get_root(self, children, item_type=None):
        raise NotImplementedError()

    def fetch(self, node=None):
        raise NotImplementedError()

    def treeify_data(self, items, item_type=None):
        """Преобразование данных в древовидную форму"""

        children = defaultdict(list)
        service_dict = {}
        roots = []
        for canonical in items:
            if canonical.parent_id is None:
                roots.append(canonical)
            service_dict[canonical.external_id] = canonical
            children[canonical.parent_id].append(canonical)

        for canonical in items:
            service_dict[canonical.external_id].children = tuple(children[canonical.external_id])

        return self.get_root(roots, item_type)
