# coding: utf-8


from django.db import models
from django.utils.translation import ugettext_lazy as _

from .updatable import UpdatableNode


class ExternalTrackingNode(UpdatableNode):
    """Модель узла, который умеет быть синхронизированным с удалённым источником,
    предоставляющим уникальные идентификаторы узлов"""

    moved_from = models.OneToOneField('self', verbose_name=_('Перемещено из узла'), null=True, blank=True,
                                      on_delete=models.SET_NULL, related_name='moved_to')

    class Meta:
        abstract = True

    def get_external_id(self):
        return getattr(self, self.EXTERNAL_ID_FIELD)

    def find_matching_child(self, data_item, nodes):
        match = None
        if self.REQUIRE_EXTERNAL_ID:
            external_id = getattr(data_item, self.EXTERNAL_ID_FIELD)
            matches = [node for node in nodes if node.external_id == external_id]
        else:
            matches = [node for node in nodes if node.get_external_id() and data_item[self.EXTERNAL_ID_FIELD] and
                       node.external_id == data_item[self._meta._external_id]]
        if len(matches) == 1:
            match = matches[0]
        return match
