# coding: utf-8


from django.contrib.admin import site, ModelAdmin

from idm.framework.base_admin import IdmModelAdminMixin
from idm.notification.models import Notice


class NoticeAdmin(IdmModelAdminMixin, ModelAdmin):
    list_display = ('recipient', 'subject', 'added')
    raw_id_fields = ('recipient',)
    search_fields = ('recipient__username', 'subject')


site.register(Notice, NoticeAdmin)
