# coding: utf-8


from django.urls import reverse
from django.db import models
from django.utils.translation import ugettext_lazy as _


class Notice(models.Model):
    recipient = models.ForeignKey(
        'users.User',
        related_name='received_notices',
        verbose_name=_('Получатель'),
        on_delete=models.CASCADE,
    )
    subject = models.TextField(_('Тема'))
    message = models.TextField(_('Сообщение'))
    added = models.DateTimeField(auto_now_add=True)
    is_seen = models.BooleanField(_('Просмотренность'), default=False)

    class Meta:
        ordering = ('is_seen', '-added')
        db_table = 'notification_notice'

    def __str__(self):
        return 'Notice for "%s" with subject "%s"' % (self.recipient, self.subject)

    def get_absolute_url(self):
        return reverse('read-notice', args=[self.id])

