# coding: utf-8


from io import BytesIO

import qrcode


def generate_qr(text):
    """
    Возвращает содержимое png-файла, содержащего QR-код с зашифрованным текстом

    @type text: basestring
    @return: str
    """
    qr = qrcode.QRCode(
        error_correction=qrcode.constants.ERROR_CORRECT_L,
        box_size=5,
    )
    qr.add_data(text)
    qr.make(fit=True)
    image = qr.make_image()

    out = BytesIO()
    image.save(out, kind='gif')

    return out.getvalue()
