# coding: utf-8



import logging
from lxml import etree
import yenv

from django.conf import settings

from idm.utils import http


log = logging.getLogger(__name__)


def send_sms(message, phone, username):
    log.info('Sending message to phone %s, (%s)', phone, username)
    if yenv.type != 'production':
        from idm.testenv.models import AllowedPhone
        if not AllowedPhone.check_phone(phone):
            error_text = 'Mobile phone is not in testing whitelist'
            log.warning('Mobile phone %s(%s) is not in testing whitelist', phone, username)
            return False, error_text
        else:
            message = '[Testing] ' + message
    params = settings.SEND_SMS_PARAMS.copy()
    params.update(text=message, phone=phone)
    response = http.get(
        settings.SEND_SMS_URL,
        params=params,
        use_client_certificate=False,
        tvm_id=settings.PASSPORT_SMS_TVM_ID,
    )
    xml = etree.fromstring(response.content)
    response_tags = [item.tag for item in xml.getchildren()]
    if 'message-sent' in response_tags:
        return True, xml.find('message-sent').attrib.get('id')
    else:
        try:
            error_text = xml.find('error').text
        except Exception:
            error_text = 'unknown error'
        log.error('Failed to send message to phone %s(%s):\n  %s', phone, username, error_text)
        return False, error_text
