# coding: utf-8
from django.db.models.aggregates import Count

from idm.core.models import Action, System


def get_actions_count_from_qs(qs) -> dict:
    return dict(
        qs.
        values_list('action').
        annotate(action_count=Count('action')).
        values_list('action', 'action_count')
    )


def get_sync_report(system: System, sync_key: Action) -> dict:
    new_actions = get_actions_count_from_qs(system.actions.filter(parent=sync_key))
    new_responsibility_actions = get_actions_count_from_qs(system.rolenoderesponsibilityactions.filter(parent=sync_key))

    success_data = {
        'status': 0,
        'report': {
            'nodes_created': new_actions.get('role_node_created', 0),
            'nodes_changed': new_actions.get('role_node_changed', 0),
            'nodes_deleted': 0,  # этот счётчик будет обновлён при deprive_nodes
            'fields_created': new_actions.get('role_node_field_created', 0),
            'fields_removed': new_actions.get('role_node_field_removed', 0),
            'fields_changed': new_actions.get('role_node_field_changed', 0),
            'aliases_created': new_actions.get('role_node_alias_created', 0),
            'aliases_removed': new_actions.get('role_node_alias_removed', 0),
            'responsibilities_created': new_responsibility_actions.get('role_node_responsibility_created', 0),
            'responsibilities_changed': new_responsibility_actions.get('role_node_responsibility_changed', 0),
            'responsibilities_removed': new_responsibility_actions.get('role_node_responsibility_removed', 0),
        }
    }

    return success_data
