# coding: utf-8


from attr import attr, attributes
from attr.validators import instance_of, optional
from idm.nodes.canonical import tuple_of, Hashable, SELF


@attributes(slots=True)
class CanonicalService(Hashable):
    external_id = attr(validator=instance_of(int))
    parent_id = attr(validator=optional(instance_of(int)), cmp=False)
    root_id = attr(validator=optional(instance_of(int)), cmp=False)

    state = attr(validator=instance_of(str))

    is_vteam = attr(validator=instance_of((bool)))

    slug = attr(validator=instance_of(str))
    name = attr(validator=instance_of(str))
    name_en = attr(validator=instance_of(str))
    description_wiki = attr(validator=instance_of(str))
    description_wiki_en = attr(validator=instance_of(str))
    description_html = attr(validator=instance_of(str))
    description_html_en = attr(validator=instance_of(str))
    membership_inheritance = attr(validator=instance_of(bool))
    children = attr(validator=tuple_of(SELF), cmp=False, repr=False, hash=False, converter=tuple, default=())
