# coding: utf-8

import logging

from django.db import models

from idm.closuretree.managers import CttManager
from idm.nodes.updatable import StatefulQuerySet


log = logging.getLogger(__name__)


class ServiceQueryset(StatefulQuerySet):
    def active_in_abc(self):
        return self.filter(external_state='develop')

    def actual_roots(self):
        """
        У нас в дереве корнем является несусществующий пустой сервис
        Этот метод не учитывает его
        """
        return self.filter(level=1)

    def nonroot(self):
        """
        У нас в дереве корнем является несусществующий пустой сервис
        Поэтому этот метод на самом деле возвращает все существующие сервисы
        """
        return self.filter(level__gt=0)

    def prefetch_for_hashing(self):
        return self.select_related('parent')


class ServiceManager(models.Manager.from_queryset(ServiceQueryset), CttManager):
    def get_root(self):
        root, _ = self.get_queryset().get_or_create(parent=None)
        return root

    def get_by_external_id(self, external_id):
        qs = self.filter(external_id=external_id)
        service = None
        try:
            service = qs.get()
        except (self.model.DoesNotExist, self.model.MultipleObjectsReturned):
            pass
        return service
