# -*- coding: utf-8 -*-


from django.db import migrations, models
import django.utils.timezone
import django.db.models.deletion
import idm.framework.mixins


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('level', models.PositiveIntegerField(default=0, editable=False, db_index=True)),
                ('state', models.CharField(default='active', max_length=255, verbose_name='\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435', db_index=True, choices=[('active', '\u0410\u043a\u0442\u0438\u0432\u0435\u043d/\u0430\u043a\u0442\u0438\u0432\u043d\u0430'), ('depriving', '\u0423\u0434\u0430\u043b\u044f\u0435\u0442\u0441\u044f'), ('deprived', '\u0423\u0434\u0430\u043b\u0451\u043d/\u0443\u0434\u0430\u043b\u0435\u043d\u0430')])),
                ('path', models.CharField(db_index=True, max_length=255, verbose_name='\u041f\u0443\u0442\u044c', blank=True)),
                ('hash', models.CharField(default='', max_length=255, verbose_name='\u0425\u0435\u0448 \u043e\u0442 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438 \u0445\u0435\u0448\u0435\u0439 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0445 \u0443\u0437\u043b\u043e\u0432', db_index=True, blank=True)),
                ('slug', models.CharField(default='', max_length=255, verbose_name='\u0421\u043b\u0430\u0433', db_index=True)),
                ('descendants_count', models.PositiveIntegerField(default=None, null=True, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0442\u043e\u043c\u043a\u043e\u0432', blank=True)),
                ('external_state', models.CharField(default='supported', max_length=255, verbose_name='\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435', db_index=True, choices=[('closed', '\u0417\u0430\u043a\u0440\u044b\u0442'), ('deleted', '\u0423\u0434\u0430\u043b\u0451\u043d'), ('develop', '\u0420\u0430\u0437\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f'), ('frozen', '\u0417\u0430\u043c\u043e\u0440\u043e\u0436\u0435\u043d'), ('supported', '\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f')])),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, verbose_name='\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f', null=True, editable=False)),
                ('updated_at', models.DateTimeField(verbose_name='\u0414\u0430\u0442\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f', null=True, editable=False)),
                ('external_id', models.IntegerField(default=0, verbose_name='\u0412\u043d\u0435\u0448\u043d\u0438\u0439 ID')),
                ('is_vteam', models.BooleanField(default=False, verbose_name='VTeam')),
                ('name', models.CharField(default='', max_length=255, verbose_name='\u0418\u043c\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430')),
                ('name_en', models.CharField(default='', max_length=255, verbose_name='\u0418\u043c\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430 (\u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c)')),
                ('description_wiki', models.TextField(default='', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (wiki)', blank=True)),
                ('description_wiki_en', models.TextField(default='', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (wiki, \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c)', blank=True)),
                ('description_html', models.TextField(default='', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (HTML)', blank=True)),
                ('description_html_en', models.TextField(default='', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (HTML, \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c)', blank=True)),
                ('moved_from', models.OneToOneField(related_name='moved_to', null=True, on_delete=django.db.models.deletion.SET_NULL, blank=True, to='services.Service', verbose_name='\u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u043e \u0438\u0437 \u0443\u0437\u043b\u0430')),
                ('parent', models.ForeignKey(related_name='children', blank=True, to='services.Service', null=True, on_delete=models.CASCADE)),
                ('root', models.ForeignKey(verbose_name='\u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0441\u0435\u0440\u0432\u0438\u0441', blank=True, to='services.Service', null=True, on_delete=models.CASCADE)),
            ],
            options={
                'verbose_name': '\u0421\u0435\u0440\u0432\u0438\u0441',
                'verbose_name_plural': '\u0421\u0435\u0440\u0432\u0438\u0441\u044b',
            },
            bases=(idm.framework.mixins.LocalizedModel, models.Model),
        ),
        migrations.CreateModel(
            name='ServiceClosure',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('depth', models.IntegerField()),
                ('child', models.ForeignKey(related_name='serviceclosure_parents', to='services.Service', on_delete=models.CASCADE)),
                ('parent', models.ForeignKey(related_name='serviceclosure_children', to='services.Service', on_delete=models.CASCADE)),
            ],
            options={
                'db_table': 'services_serviceclosure',
            },
        ),
        migrations.AlterUniqueTogether(
            name='serviceclosure',
            unique_together=set([('parent', 'child')]),
        ),
    ]
