# -*- coding: utf-8 -*-


from collections import Counter

from django.db import migrations, models


def forwards_func(apps, schema_editor):
    """
        Был баг из-за которого вместо external_state состояние писалось в state, из-за этого
        при синхронизации сервис считался неактивным, т.к. state != 'active',и создавался
        ещё один сервис. Нужно поставить всем 'active' в state и удалить дупликаты

    """

    Service = apps.get_model('services', 'Service')
    Service.objects.all().update(state='active')

    external_ids_counter = Counter(Service.objects.values_list('external_id', flat=True))
    for external_id, count in external_ids_counter.items():
        if count > 1:
            # Выбираем первый добавленный сервис
            service_to_keep = Service.objects.filter(external_id=external_id).earliest('created_at')

            # Удаляем остальные сервисы
            Service.objects.filter(external_id=external_id).exclude(id=service_to_keep.id).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(
            forwards_func,
            migrations.RunPython.noop
        ),
        migrations.AlterField(
            model_name='service',
            name='external_id',
            field=models.IntegerField(default=0, unique=True, verbose_name='\u0412\u043d\u0435\u0448\u043d\u0438\u0439 ID'),
        ),
        migrations.AlterField(
            model_name='service',
            name='external_state',
            field=models.CharField(default='unknown_state', max_length=255, verbose_name='\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435', db_index=True),
        ),
    ]
