# coding: utf-8
from django.conf import settings
from django.utils import timezone

from idm.core.utils import create_or_update_model
from idm.celery_app import app
from idm.framework.task import BaseTask
from idm.services.sync.services import sync_services


class SyncServices(BaseTask):
    monitor_success = False  # кастомное логирование из-за наличия неблокирующего лока

    def init(self):
        task_start = timezone.now()

        was_executed = sync_services()

        if was_executed and settings.ENABLE_COMMAND_MONITORING:
            from idm.core.models import CommandTimestamp
            create_or_update_model(
                model=CommandTimestamp,
                obj_filter={'command': self.task_name},
                defaults={
                    'last_success_start': task_start,
                    'last_success_finish': timezone.now(),
                }
            )


SyncServices = app.register_task(SyncServices())
