DROP PROCEDURE IF EXISTS {table_name}_add_missing_closures $$

CREATE PROCEDURE {table_name}_add_missing_closures()
BEGIN
    DECLARE eof INT DEFAULT FALSE;
    DECLARE node_pk INT;
    DECLARE node_parent_pk INT;
    DECLARE node_counter INT DEFAULT 0;
    DECLARE curs CURSOR FOR SELECT id, parent_id FROM {table_name} ORDER BY level;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET eof = TRUE;
    START TRANSACTION;
    OPEN curs;
    select_loop: LOOP
        FETCH curs INTO node_pk, node_parent_pk;
        IF eof THEN
            LEAVE select_loop;
        END IF;

        INSERT IGNORE INTO {table_name}closure (depth, child_id, parent_id) VALUES (0, node_pk, node_pk);

        IF node_parent_pk IS NOT NULL THEN
            INSERT IGNORE INTO {table_name}closure (depth, child_id, parent_id) SELECT depth + 1, node_pk, parent_id FROM {table_name}closure WHERE child_id = node_parent_pk;
        END IF;

        SET node_counter := node_counter + 1;
        IF node_counter % 10000 = 0 THEN
            COMMIT;
            START TRANSACTION;
        END IF;
    END LOOP;
    CLOSE curs;
    COMMIT;
END
