# coding: utf-8


import logging

from idm.core.constants.system import SYSTEM_CONSTANTS
from idm.framework.requester import requesterify

log = logging.getLogger(__name__)

SYNC_NODES_ONLY = ('sync_nodes', 'deprive_nodes')
DEPRIVE_NODES_ONLY =('deprive_nodes',)
SYNC_ROLES_ONLY = ('check_inconsistencies', 'resolve_inconsistencies')
CHECK_ROLES_ONLY = ('check_inconsistencies',)

SYNC_EVERYTHING = (
    'sync_nodes',
    'deprive_nodes',
    'report_unchecked',
    'check_inconsistencies',
    'report_inconsistencies',
    'resolve_inconsistencies',
)

SYNC_NOTHING = ()


def sync_roles_and_nodes(system, steps=SYNC_NOTHING, from_web=False, from_api=False, **kwargs):
    from idm.core.tasks.everysync import EverySync, ALL_STEPS

    size = SYSTEM_CONSTANTS.SIZE_SMALL
    if SYNC_NODES_ONLY in steps:
        size = system.get_estimated_tree_size()

    if size == SYSTEM_CONSTANTS.SIZE_BIG:
        queue_size = 'big'
    else:
        queue_size = 'small'

    if from_web:
        queue_name = 'sync_web_%s' % queue_size
    else:
        queue_name = 'sync_%s' % queue_size

    initial = next(step for step in ALL_STEPS if step in steps)
    kwargs.update({
        'requester': requesterify(kwargs.get('requester')).as_dict(),
        'system_slug': system.slug,
        'steps': list(steps),
        'step': initial,
        'from_api': from_api,
    })
    EverySync.apply_async(kwargs=kwargs, queue=queue_name)
