# coding: utf-8


import logging

from idm.users.constants.user import USER_TYPES
from idm.users.models import User

log = logging.getLogger(__name__)


def is_user_absent(username):
    is_absent = False
    try:
        is_absent = User.objects.users().get(username=username).is_absent
    except User.DoesNotExist:
        log.exception('No user with username %s', username)
    return is_absent
