# coding: utf-8


from django.conf import settings
import intrasearch_fetcher

from ids import exceptions
from ids.registry import registry

from idm.api.exceptions import InternalAPIError


class IntrasearchFetcher(intrasearch_fetcher.IntrasearchFetcher):
    def __init__(self, layer):
        super(IntrasearchFetcher, self).__init__(
            layer,
            settings.IDM_IDS_USER_AGENT,
            settings.IDM_STAFF_OAUTH_TOKEN,
            settings.IDM_SUGGEST_TIMEOUT,
        )

    @staticmethod
    def convert(limit, offset):
        if limit > offset:
            return 0, limit + offset, offset, limit + offset

        for per_page in range(limit, limit + offset + 1):
            total_gap = per_page - limit
            front_gap = offset % per_page
            if front_gap <= total_gap:
                page = offset // per_page
                return page, per_page, front_gap, limit + front_gap
