# coding: utf-8

from django.conf.urls import include, url
from django.contrib import admin

from ajax_select import urls as ajax_select_urls

from idm.api.urls import urlpatterns as api_urlpatterns
from idm.monitorings import urls as monitorings_urls
from idm.core.admin import idm_site
from idm.ping.views import ping

admin.autodiscover()
idm_site._registry = admin.site._registry

urlpatterns = [
    url(r'^admin/lookups/', include(ajax_select_urls)),  # ajax-select lookup channels for django-admin
    url(r'^admin/', idm_site.urls),
]

urlpatterns += [
    url(r'^client-api/', include(('django_idm_api.urls', 'core'), namespace='client-api')),
    url(r'^ping/?$', ping),
    url(r'^ping-backend/?$', ping),
    url(r'^monitorings/', include(monitorings_urls)),
]

urlpatterns += api_urlpatterns
