# coding: utf-8


from attr import attr, attributes, Factory
from attr.validators import instance_of, optional
from idm.nodes.canonical import tuple_of, either, Hashable, SELF, dict_of
from idm.users import ranks


@attributes(slots=True)
class CanonicalMember(object):
    staff_id = attr(validator=instance_of(int))
    state = attr(validator=instance_of(str))

    def as_key(self):
        return self.staff_id, self.state


@attributes(slots=True)
class CanonicalGroupResponsibility(object):
    staff_id = attr(validator=instance_of(int))
    rank = attr(validator=either(*ranks.ALL_RANKS))

    def as_key(self):
        return self.staff_id, self.rank


@attributes(slots=True)
class CanonicalGroup(Hashable):
    type = attr(validator=instance_of(str))
    external_id = attr(validator=instance_of(int))
    parent_id = attr(validator=optional(instance_of(int)), cmp=False)

    slug = attr(validator=instance_of(str), default='')
    description = attr(validator=instance_of(str), default='')
    name = attr(validator=instance_of(str), default='')
    name_en = attr(validator=instance_of(str), default='')

    members = attr(validator=dict_of(CanonicalMember), default=Factory(dict))
    responsibles = attr(validator=dict_of(CanonicalGroupResponsibility), default=Factory(dict))

    children = attr(validator=tuple_of(SELF), cmp=False, repr=False, hash=False, converter=tuple, default=())
