# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2019-07-30 10:38


from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import idm.framework.mixins
import idm.users.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0007_alter_validators_add_error_messages'),
        ('core', '0001_new_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Subject',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('username', models.CharField(default='', max_length=255, verbose_name='\u041b\u043e\u0433\u0438\u043d \u0438\u043b\u0438 URL')),
                ('first_name', models.CharField(default='', max_length=255, verbose_name='\u0418\u043c\u044f')),
                ('last_name', models.CharField(default='', max_length=255, verbose_name='\u0424\u0430\u043c\u0438\u043b\u0438\u044f')),
                ('parent_name', models.CharField(default='', max_length=255, verbose_name='\u0418\u043c\u044f \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b')),
                ('full_name', models.CharField(default='', max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('full_name_en', models.CharField(default='', max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c')),
                ('is_group', models.BooleanField(default=False, verbose_name='\u0413\u0440\u0443\u043f\u043f\u0430')),
                ('subject_type', models.CharField(choices=[('user', '\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c'), ('group', '\u0413\u0440\u0443\u043f\u043f\u0430')], max_length=255, null=True, verbose_name='\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430')),
                ('group_type', models.CharField(choices=[('department', '\u0414\u0435\u043f\u0430\u0440\u0442\u0430\u043c\u0435\u043d\u0442'), ('service', '\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430'), ('tvm_service', 'TVM \u0441\u0435\u0440\u0432\u0438\u0441'), ('wiki', '\u0412\u0438\u043a\u0438-\u0433\u0440\u0443\u043f\u043f\u0430')], max_length=255, null=True, verbose_name='\u0422\u0438\u043f \u0433\u0440\u0443\u043f\u043f\u044b')),
                ('external_id', models.CharField(default='', max_length=255, verbose_name='ID \u0432 \u0421\u0442\u0430\u0444\u0444\u0435')),
            ],
            options={
                'verbose_name': '\u041e\u0431\u044a\u0435\u043a\u0442 \u0432\u044b\u0434\u0430\u0447\u0438 \u0440\u043e\u043b\u0438',
                'db_table': 'users_subject',
                'managed': False,
                'verbose_name_plural': '\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u0432\u044b\u0434\u0430\u0447\u0438 \u0440\u043e\u043b\u0438',
            },
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 30 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=30, unique=True, validators=[django.core.validators.RegexValidator('^[\\w.@+-]+$', 'Enter a valid username. This value may contain only letters, numbers and @/./+/-/_ characters.')], verbose_name='username')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('fired_at', models.DateField(blank=True, null=True)),
                ('contract_ends_at', models.DateField(blank=True, null=True)),
                ('nda_ends_at', models.DateField(blank=True, null=True)),
                ('guid', models.CharField(default=None, max_length=47, null=True, unique=True)),
                ('sex', models.CharField(choices=[('M', 'male'), ('F', 'female')], max_length=1, null=True)),
                ('staff_id', models.IntegerField(null=True)),
                ('imported_at', models.DateTimeField(db_index=True, null=True)),
                ('type', models.TextField(choices=[('user', 'user'), ('tvm_app', 'tvm_app')], db_index=True, default='user', verbose_name='\u0422\u0438\u043f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f')),
                ('center_id', models.IntegerField(db_index=True, default=0)),
                ('lang_ui', models.CharField(default='ru', max_length=10)),
                ('first_name', models.TextField(blank=True, default='')),
                ('last_name', models.TextField(blank=True, default='')),
                ('first_name_en', models.TextField(blank=True, default='')),
                ('last_name_en', models.TextField(blank=True, default='')),
                ('ldap_active', models.NullBooleanField(default=None)),
                ('ldap_blocked', models.BooleanField(default=False)),
                ('is_absent', models.BooleanField(default=False)),
                ('is_homeworker', models.BooleanField(default=False)),
                ('is_robot', models.BooleanField(default=False)),
                ('mobile_phone', models.CharField(blank=True, max_length=15, null=True)),
                ('updated', models.DateTimeField(auto_now_add=True)),
                ('position', models.CharField(default='', max_length=150)),
                ('affiliation', models.CharField(choices=[('yandex', 'yandex'), ('yamoney', 'yamoney'), ('external', 'external'), ('other', 'other')], db_index=True, default='other', max_length=8)),
            ],
            options={
                'db_table': 'upravlyator_user',
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
            },
            managers=[
                ('objects', idm.users.managers.BaseIDMUsersManager()),
            ],
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('slug', models.CharField(max_length=255)),
                ('added', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('chief', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='head_of', to=settings.AUTH_USER_MODEL)),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='subdeps', to='users.Department')),
                ('users', models.ManyToManyField(related_name='departments', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'upravlyator_department',
            },
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.PositiveIntegerField(db_index=True, default=0, editable=False)),
                ('state', models.CharField(choices=[('active', '\u0410\u043a\u0442\u0438\u0432\u0435\u043d/\u0430\u043a\u0442\u0438\u0432\u043d\u0430'), ('depriving', '\u0423\u0434\u0430\u043b\u044f\u0435\u0442\u0441\u044f'), ('deprived', '\u0423\u0434\u0430\u043b\u0451\u043d/\u0443\u0434\u0430\u043b\u0435\u043d\u0430')], db_index=True, default='active', max_length=255, verbose_name='\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435')),
                ('path', models.CharField(blank=True, db_index=True, max_length=255, verbose_name='\u041f\u0443\u0442\u044c')),
                ('hash', models.CharField(blank=True, db_index=True, default='', max_length=255, verbose_name='\u0425\u0435\u0448 \u043e\u0442 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438 \u0445\u0435\u0448\u0435\u0439 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0445 \u0443\u0437\u043b\u043e\u0432')),
                ('slug', models.CharField(db_index=True, default='', max_length=255, verbose_name='\u0421\u043b\u0430\u0433')),
                ('descendants_count', models.PositiveIntegerField(blank=True, default=None, null=True, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0442\u043e\u043c\u043a\u043e\u0432')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f')),
                ('updated_at', models.DateTimeField(editable=False, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f')),
                ('expire_at', models.DateTimeField(editable=False, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u043e\u0442\u0437\u044b\u0432\u0430')),
                ('external_id', models.IntegerField(default=0, verbose_name='\u0412\u043d\u0435\u0448\u043d\u0438\u0439 ID')),
                ('name', models.CharField(db_index=True, default='', max_length=255, verbose_name='\u0418\u043c\u044f \u0433\u0440\u0443\u043f\u043f\u044b')),
                ('name_en', models.CharField(db_index=True, default='', max_length=255, verbose_name='\u0418\u043c\u044f \u0433\u0440\u0443\u043f\u043f\u044b (\u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c)')),
                ('description', models.TextField(blank=True, default='', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435')),
                ('type', models.CharField(choices=[('department', '\u0414\u0435\u043f\u0430\u0440\u0442\u0430\u043c\u0435\u043d\u0442'), ('service', '\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430'), ('tvm_service', 'TVM \u0441\u0435\u0440\u0432\u0438\u0441'), ('wiki', '\u0412\u0438\u043a\u0438-\u0433\u0440\u0443\u043f\u043f\u0430')], db_index=True, default='department', max_length=255, verbose_name='\u0422\u0438\u043f \u0433\u0440\u0443\u043f\u043f\u044b')),
                ('moved_from', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='moved_to', to='users.Group', verbose_name='\u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u043e \u0438\u0437 \u0443\u0437\u043b\u0430')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='users.Group')),
            ],
            options={
                'verbose_name': '\u0413\u0440\u0443\u043f\u043f\u0430',
                'verbose_name_plural': '\u0413\u0440\u0443\u043f\u043f\u044b',
            },
            bases=(idm.framework.mixins.LocalizedModel, models.Model, idm.framework.mixins.DifferenceTableMixin),
        ),
        migrations.CreateModel(
            name='GroupClosure',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('depth', models.IntegerField()),
                ('child', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='groupclosure_parents', to='users.Group')),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='groupclosure_children', to='users.Group')),
            ],
            options={
                'db_table': 'users_groupclosure',
            },
        ),
        migrations.CreateModel(
            name='GroupMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_joined', models.DateTimeField(default=None, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0432\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u044f \u0432 \u0433\u0440\u0443\u043f\u043f\u0443')),
                ('date_leaved', models.DateTimeField(default=None, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0430 \u0438\u0437 \u0433\u0440\u0443\u043f\u043f\u044b')),
                ('state', models.TextField(choices=[('active', '\u0410\u043a\u0442\u0438\u0432\u043d\u043e'), ('inactive', '\u041d\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u043e')], db_index=True, default='inactive', verbose_name='\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435')),
                ('is_direct', models.BooleanField(db_index=True)),
                ('notified_about_passport_login', models.NullBooleanField(db_index=True, default=False)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='memberships', to='users.Group', verbose_name='\u0413\u0440\u0443\u043f\u043f\u0430')),
                ('passport_login', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_memberships', to='core.UserPassportLogin', verbose_name='\u041f\u0430\u0441\u043f\u043e\u0440\u0442\u043d\u044b\u0439 \u043b\u043e\u0433\u0438\u043d')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='memberships', to=settings.AUTH_USER_MODEL, verbose_name='\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c')),
            ],
            options={
                'verbose_name': '\u0427\u043b\u0435\u043d\u0441\u0442\u0432\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0432 \u0433\u0440\u0443\u043f\u043f\u0435',
                'verbose_name_plural': '\u0427\u043b\u0435\u043d\u0441\u0442\u0432\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0432 \u0433\u0440\u0443\u043f\u043f\u0430\u0445',
            },
        ),
        migrations.CreateModel(
            name='GroupResponsibility',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rank', models.CharField(choices=[('head', '\u0413\u043b\u0430\u0432\u0430'), ('deputy', '\u0417\u0430\u043c\u0435\u0441\u0442\u0438\u0442\u0435\u043b\u044c'), ('hr_partner', 'HR-\u043f\u0430\u0440\u0442\u043d\u0451\u0440'), ('budget_holder', '\u0414\u0435\u0440\u0436\u0430\u0442\u0435\u043b\u044c \u0431\u044e\u0434\u0436\u0435\u0442\u0430'), ('general_director', '\u0413\u0435\u043d\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440')], db_index=True, max_length=50, null=True, verbose_name='\u0421\u0442\u0430\u0442\u0443\u0441 \u0432 \u0433\u0440\u0443\u043f\u043f\u0435')),
                ('date_joined', models.DateTimeField(default=None, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u0437\u0430 \u0433\u0440\u0443\u043f\u043f\u0443')),
                ('date_leaved', models.DateTimeField(default=None, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u0437\u0430 \u0433\u0440\u0443\u043f\u043f\u0443')),
                ('is_active', models.BooleanField(db_index=True, default=False)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='responsibilities', to='users.Group', verbose_name='\u0413\u0440\u0443\u043f\u043f\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u043c')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='responsibilities', to=settings.AUTH_USER_MODEL, verbose_name='\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c')),
            ],
            options={
                'verbose_name': '\u041e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0432 \u0433\u0440\u0443\u043f\u043f\u0435',
                'verbose_name_plural': '\u041e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0432 \u0433\u0440\u0443\u043f\u043f\u0430\u0445',
            },
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('org_id', models.IntegerField(db_index=True)),
                ('is_active', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='OrganizationMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(default=True)),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='memberships', to='users.Organization')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='organization_memberships', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='user',
            name='department',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='users2', to='users.Department'),
        ),
        migrations.AddField(
            model_name='user',
            name='department_group',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='employees', to='users.Group'),
        ),
        migrations.AddField(
            model_name='user',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='user',
            name='responsibles',
            field=models.ManyToManyField(related_name='robots', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='user',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
        migrations.AlterUniqueTogether(
            name='groupresponsibility',
            unique_together=set([('user', 'group', 'rank')]),
        ),
        migrations.AlterIndexTogether(
            name='groupresponsibility',
            index_together=set([('user', 'group', 'rank', 'is_active')]),
        ),
        migrations.AlterUniqueTogether(
            name='groupmembership',
            unique_together=set([('user', 'group', 'is_direct')]),
        ),
        migrations.AlterIndexTogether(
            name='groupmembership',
            index_together=set([('user', 'group', 'state')]),
        ),
        migrations.AlterUniqueTogether(
            name='groupclosure',
            unique_together=set([('parent', 'child')]),
        ),
        migrations.AlterUniqueTogether(
            name='user',
            unique_together=set([('username', 'type')]),
        ),
    ]
