# coding: utf-8
from typing import TypeVar, Iterable, List

import simplejson as json  # NOQA
from django.urls import reverse as _reverse

__all__ = ('reverse', 'min_with_none', 'json', 'chunkify')


def reverse(view_name, *args, **kwargs):
    """Более удобный реверс урла"""
    return _reverse(view_name, args=args, kwargs=kwargs)


def min_with_none(*seq):
    seq = [value for value in seq if value is not None]
    if seq:
        return min(seq)
    return None


def coroutine(func):
    def start(*args,**kwargs):
        coro = func(*args,**kwargs)
        next(coro)
        return coro
    return start


T = TypeVar('T')


def chunkify(iterable: Iterable[T], chunk_size: int) -> Iterable[List[T]]:
    if chunk_size < 1:
        raise ValueError('Chunk size should be positive integer')
    _iterator = iter(iterable)
    while True:
        chunk = []
        for _ in range(chunk_size):
            try:
                chunk.append(next(_iterator))
            except StopIteration:
                if chunk:
                    yield chunk
                return
        else:
            yield chunk