import datetime

from django.utils import timezone

from idm.integration import calendar


def get_next_workday(dt: datetime.datetime = None, with_time: datetime.time = None):
    dt = dt or timezone.now()
    workday = dt.date()
    holidays = calendar.get_holidays(workday)
    while holidays:
        holiday = holidays.pop(0)
        if workday > holiday:  # на всякий случай
            continue
        if workday == holiday:
            workday += timezone.timedelta(days=1)
            if not holidays:
                holidays.extend(calendar.get_holidays(workday))
            continue
        break
    return datetime.datetime.combine(workday, with_time or dt.time(), tzinfo=dt.tzinfo)
