import logging
from functools import wraps

import waffle

log = logging.getLogger(__name__)


def check_switch(*switches: str, return_=None, raise_=None):
    """
    Перед вызовом декорируемого метода проверим свич.
    Если свитч включен, то вместо вызова:
    :param return_: будет возвращено это значение
    :param raise_: вместо возврата будет поднято исключение
    """

    def decorator(f):
        @wraps(f)
        def wrapper(*args, **kwargs):
            for switch in switches:
                if waffle.switch_is_active(switch):
                    log.info('omit function call because of switch. function: %s, switch: %s', f.__name__, switch)
                    if raise_:
                        raise raise_
                    return return_
            return f(*args, **kwargs)

        return wrapper

    return decorator


