# coding: utf-8

from functools import wraps

from django.utils import translation

LANG_UNIONS = {'and': translation.gettext_lazy('и'), 'or': translation.gettext_lazy('или')}
ROLE_VERB = {
    'requested': {
        'M': translation.gettext_lazy('запросил'),
        'F': translation.gettext_lazy('запросила'),
    },
    'declined': {
        'M': translation.gettext_lazy('отклонил'),
        'F': translation.gettext_lazy('отклонила'),
    },
    'granted': {
        'M': translation.gettext_lazy('выдал'),
        'F': translation.gettext_lazy('выдала'),
    },
    'deprived': {
        'M': translation.gettext_lazy('отозвал'),
        'F': translation.gettext_lazy('отозвала'),
    },
    'approved': {
        'M': translation.gettext_lazy('подтвердил'),
        'F': translation.gettext_lazy('подтвердила'),
    },
}

def set_translation(func):
    @wraps(func)
    def wrapper(*args, **kwargs):
        with translation.override('ru'):
            return func(*args, **kwargs)
    return wrapper


def get_lang_pair(name_or_dict):
    """Функция принимает строку или словарь. Если аргумент - строка, то возвращает пару таких же строк, если
    аргумент - словарь, то ищет строки в ключах 'ru' и 'en'"""
    if isinstance(name_or_dict, str):
        field_ru = field_en = name_or_dict
    else:
        field_ru = name_or_dict.get('ru', '')
        field_en = name_or_dict.get('en', field_ru)
    return field_ru, field_en


def get_lang_key(default=None):
    lang = translation.get_language()
    if lang is None:
        return default
    else:
        return lang[:2]


def get_localized_fieldname(field, lang=None):
    if lang is None:
        lang = get_lang_key()
    if lang == 'ru':
        fieldname = field
    else:
        fieldname = '%s_en' % field
    return fieldname
