# coding: utf-8
import time
from contextlib import contextmanager

from ylog import context


@contextmanager
def log_duration(log, process_name, *args, **kwargs):
    start_time = time.monotonic()
    success = True
    try:
        log.info(process_name, *args, **kwargs)
        yield
    except Exception:
        success = False
        raise
    finally:
        message = '%s: finished. Success: %s. Time: %s' % (process_name, success, time.monotonic() - start_time)
        log.info(message, *args, **kwargs)


@contextmanager
def no_log_context(*_, **__):
    # пустышка вместо django_tools_log_context.RequestLogContext
    class context:
        def __init__(self):
            self.context = {}

    yield context()


@contextmanager
def log_subcontext(subcontext: str, **kwargs):
    ctx = context.pop_from_context(subcontext) or {}
    ctx.update(kwargs)
    context.put_to_context(subcontext, ctx)
    yield
    context.pop_from_context(subcontext)
