# coding: utf-8


from django.db import models

from idm.utils import json


class JSONDict(dict):

    def __str__(self):
        return json.dumps(self, sort_keys=True)


class JSONList(list):

    def __str__(self):
        return json.dumps(self, sort_keys=True)


class JSONField(models.TextField):
    """ Поле для хранения данных, сериализованных в JSON. """

    editable = False
    serialize = False

    def load_json(self, value):
        """Вспомогательная функция для распаковки данных из строки"""
        try:
            value = json.loads(value)
            if isinstance(value, list):
                value = JSONList(value)
            elif isinstance(value, dict):
                value = JSONDict(value)
        except ValueError:
            pass
        return value

    def from_db_value(self, value, expression, connection, context):
        if value is None:
            return value
        return self.load_json(value)

    def get_prep_value(self, value):
        if value is not None:
            return json.dumps(value, sort_keys=True)

    def to_python(self, value):

        if value is None:
            return value
        elif not isinstance(value, str):
            return value
        if value:
            return self.load_json(value)
        return None
