import functools


def raise_if_unsaved(func):
    @functools.wraps(func)
    def _fn(self, *args, **kwargs):
        if not self.pk:
            raise ValueError(
                'Cannot call %(function)s on unsaved %(class)s instances'
                % {'function': func.__name__, 'class': self.__class__.__name__}
            )
        return func(self, *args, **kwargs)
    return _fn


def get_abstract_model_without_some_fields(model_class, fields):
    assert model_class._meta.abstract

    for field in list(model_class._meta.local_fields):
        if field.name in fields:
            model_class._meta.local_fields.remove(field)

    return model_class
