from typing import *

from django.conf import settings
from pymongo import MongoClient
from pymongo.database import Database


def get_mongo_db() -> Database:
    db_name = settings.BROKER_URL.split('/')[-1]
    return MongoClient(
        host=settings.BROKER_URL,
        username=settings.BROKER_USER,
        password=settings.BROKER_PASSWORD,
    )[db_name]


def get_queue_size(queue: str, mongo_db: Optional[Database] = None) -> int:
    mongo_db = mongo_db or get_mongo_db()
    return mongo_db.messages.count({'queue': queue})
