import openpyxl


COLOR_CONFLICT = 'FFC00000'
COLOR_OK = 'FF92D050'
ROLE_COLUMN = 'D'
ROLE_ROW = 3
START_COLUMN_INDEX = 5
START_ROW_INDEX = 4


def color(cell):
    return cell.fill.start_color.rgb


def get_sheet_by_title(workbook, title):
    return [sheet for sheet in workbook.worksheets if sheet.title == title][0]


def get_conflicts(workbook):
    conflicts = []
    sheet = get_sheet_by_title(workbook, 'Conflict_Roles_Matrix')
    rows = list(sheet.rows)[START_ROW_INDEX:]
    for row in rows:
        cells = row[START_COLUMN_INDEX:]
        if color(cells[0]) not in (COLOR_OK, COLOR_CONFLICT):
            continue
        for cell in cells:
            if cell.value:
                break
            if color(cell) == COLOR_CONFLICT:
                role_1 = sheet[ROLE_COLUMN + str(cell.row)].value
                role_2 = sheet[cell.column_letter + str(ROLE_ROW)].value
                if not role_1 or not role_2:
                    continue
                conflicts.append((role_1, role_2))
    return conflicts


def get_conflicts_representation(conflicts):
    stringified_conflicts = ["    ('{}', '{}'),".format(a, b) for a, b in conflicts]
    result = 'CONFLICT_DATA = [\n%s\n]' % '\n'.join(stringified_conflicts)
    return result


def generate_workflow(path):
    workbook = openpyxl.load_workbook(path)
    conflicts = get_conflicts(workbook)
    return get_conflicts_representation(conflicts)
