# coding: utf-8


import re

from django.conf import settings


def login_is_valid(passport_login):
    passport_login_prohibited_symbols_regex = re.compile(settings.IDM_PASSPORT_LOGIN_PROHIBITED_SYMBOLS)
    return not (
        passport_login_prohibited_symbols_regex.search(passport_login) or
        passport_login[0].isdigit() or
        passport_login[0] in ('.', '-') or
        passport_login[-1] in ('.', '-') or
        '..' in passport_login or
        '--' in passport_login or
        '.-' in passport_login or
        '-.' in passport_login
    )
