def queryset_iterator(queryset, chunk_size=1000):
    qs = queryset = queryset.order_by('pk')
    while True:
        obj = None
        chunk = qs[:chunk_size]
        count = 0
        for obj in chunk:
            count += 1
            yield obj
        if obj is None or count < chunk_size:
            break
        qs = queryset.filter(pk__gt=obj.pk)
