package ru.yandex.intranet.imscore.core.domain.IdentityTypeSource;

import java.util.Objects;
import java.util.Set;

import com.google.common.collect.ImmutableSet;
import org.jetbrains.annotations.NotNull;

/**
 * Identity type source
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class IdentityTypeSource {

    private final String id;
    private final Set<Integer> allowedTvmIds;

    public IdentityTypeSource(String id, Set<Integer> allowedTvmIds) {
        this.id = id;
        this.allowedTvmIds = allowedTvmIds == null
                ? Set.of()
                : ImmutableSet.copyOf(allowedTvmIds);
    }

    public String getId() {
        return id;
    }

    @NotNull
    public Set<Integer> getAllowedTvmIds() {
        return allowedTvmIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityTypeSource that)) {
            return false;
        }

        if (!Objects.equals(id, that.id)) {
            return false;
        }
        return Objects.equals(allowedTvmIds, that.allowedTvmIds);
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (allowedTvmIds != null ? allowedTvmIds.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "IdentityTypeSource{" +
                "id=" + id +
                ", allowedTvmIds=" + allowedTvmIds +
                '}';
    }
}
