package ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.specification;

import java.util.Objects;
import java.util.Set;

/**
 * Create identity type source specification.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class CreateIdentityTypeSourceSpecification {

    private final String id;
    private final Set<Integer> allowedTvmIds;

    public CreateIdentityTypeSourceSpecification(String id, Set<Integer> allowedTvmIds) {
        this.id = id;
        this.allowedTvmIds = allowedTvmIds;
    }

    public String getId() {
        return id;
    }

    public Set<Integer> getAllowedTvmIds() {
        return allowedTvmIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateIdentityTypeSourceSpecification that)) {
            return false;
        }
        return Objects.equals(id, that.id) && Objects.equals(allowedTvmIds, that.allowedTvmIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, allowedTvmIds);
    }

    @Override
    public String toString() {
        return "CreateIdentityTypeSourceSpecification{" +
                "id='" + id + '\'' +
                ", allowedTvmIds=" + allowedTvmIds +
                '}';
    }
}
