package ru.yandex.intranet.imscore.core.domain.identity;

import java.util.Optional;
import java.util.UUID;

public record IdentityIdOneOf(Optional<UUID> id, Optional<IdentityExternalId> externalId) {
    public IdentityIdOneOf(UUID id, IdentityExternalId externalId) {
        this(Optional.ofNullable(id), Optional.ofNullable(externalId));
    }

    public IdentityIdOneOf(UUID id) {
        this(Optional.of(id), Optional.empty());
    }

    public IdentityIdOneOf(IdentityExternalId externalId) {
        this(Optional.empty(), Optional.of(externalId));
    }

    public boolean hasId() {
        return id.isPresent();
    }
}
