package ru.yandex.intranet.imscore.core.domain.identity.specification;

import java.util.Optional;

import ru.yandex.intranet.imscore.core.domain.identity.IdentityExternalId;
import ru.yandex.intranet.imscore.core.domain.identity.IdentityIdOneOf;

/**
 * Create identity specification
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public record CreateIdentitySpecification(IdentityExternalId identityExternalId,
                                          Optional<IdentityIdOneOf> parentId,
                                          Optional<ModifiableIdentityDataSpecification> identityDataSpecification) {
    public CreateIdentitySpecification(IdentityExternalId identityExternalId,
                                       IdentityIdOneOf parentId,
                                       ModifiableIdentityDataSpecification identityDataSpecification) {
        this(identityExternalId, Optional.ofNullable(parentId), Optional.ofNullable(identityDataSpecification));
    }
}
