package ru.yandex.intranet.imscore.core.domain.identity.specification;

import java.util.UUID;

import ru.yandex.intranet.imscore.core.domain.identity.IdentityExternalId;
import ru.yandex.intranet.imscore.core.domain.identity.IdentityIdOneOf;

/**
 * Delete identity specification.
 * Expected to be provided id or externalId with typeId
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public record DeleteIdentitySpecification(IdentityIdOneOf identityIdOneOf) {
    public DeleteIdentitySpecification(UUID id) {
        this(new IdentityIdOneOf(id, null));
    }

    public DeleteIdentitySpecification(String externalId, String typeId) {
        this(new IdentityIdOneOf(null, new IdentityExternalId(externalId, typeId)));
    }
}
