package ru.yandex.intranet.imscore.core.domain.identity.specification;

import java.util.Optional;
import java.util.UUID;

import org.jetbrains.annotations.Nullable;

import ru.yandex.intranet.imscore.core.domain.identity.IdentityExternalId;
import ru.yandex.intranet.imscore.core.domain.identity.IdentityIdOneOf;

/**
 * Upsert identity specification
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public record UpdateIdentitySpecification(IdentityIdOneOf identityIdOneOf,
                                          Optional<ModifiableIdentityDataSpecification> identityDataSpecification) {
    public UpdateIdentitySpecification(UUID id,
                                       @Nullable ModifiableIdentityDataSpecification identityDataSpecification) {
        this(new IdentityIdOneOf(id, null), Optional.ofNullable(identityDataSpecification));
    }

    public UpdateIdentitySpecification(IdentityExternalId externalId,
                                       @Nullable ModifiableIdentityDataSpecification identityDataSpecification) {
        this(new IdentityIdOneOf(null, externalId), Optional.ofNullable(identityDataSpecification));
    }
}
