package ru.yandex.intranet.imscore.core.domain.identityRelation

import ru.yandex.intranet.imscore.core.domain.identity.Identity
import java.util.*

/**
 * Identity relation domain
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
data class IdentityRelation(
    val identityId: UUID,
    val groupId: UUID,
    val connectionType: ConnectionType = ConnectionType.UNDEFINED,
) {

    var identity: Identity? = null

    var group: Identity? = null

    enum class ConnectionType(val value: Int) {
        UNDEFINED(0), OWNERSHIP(1), MEMBERSHIP(2);

        companion object {
            fun fromInt(value: Int) = ConnectionType.values().first { it.value == value }
        }
    }
}


