package ru.yandex.intranet.imscore.core.exceptions;

import java.util.UUID;

/**
 * Exception throws on cycle detect.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class CycleException extends RuntimeException {

    public CycleException(String externalId, String typeId) {
        super(String.format("Cycle detect for identity with externalId %s and typeId %s", externalId, typeId));
    }

    public CycleException(UUID id) {
        super(String.format("Cycle detect for identity with id %s", id.toString()));
    }
}
