package ru.yandex.intranet.imscore.core.exceptions.identity

import ru.yandex.intranet.imscore.core.exceptions.ResourceNotFoundException
import java.util.*

/**
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
class IdentityNotFoundException(
    override val message: String = "",
) : ResourceNotFoundException() {
        constructor(id: UUID) : this(
            String.format("resource with id %s not found", id.toString())
        )

        constructor(externalId: String, typeId: String) : this(
            String.format(
                "resource with externalId %s and typeId %s not found",
                externalId, typeId)
        )
}

