package ru.yandex.intranet.imscore.core.exceptions.identityType;

import org.jetbrains.annotations.NotNull;

import ru.yandex.intranet.imscore.core.exceptions.ResourceNotFoundException;

/**
 * Identity type not found exception
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class IdentityTypeNotFoundException extends ResourceNotFoundException {
    public IdentityTypeNotFoundException(@NotNull String id) {
        super(String.format("IdentityType with id %s not found", id), null);
    }
}
