package ru.yandex.intranet.imscore.core.ports.identity

import ru.yandex.intranet.imscore.core.domain.identity.Identity
import ru.yandex.intranet.imscore.core.domain.identity.specification.GetIdentityByExternalIdSpecification
import ru.yandex.intranet.imscore.core.domain.identity.specification.GetIdentityByIdSpecification
import ru.yandex.intranet.imscore.core.domain.identity.specification.IdentityChildListSpecification
import ru.yandex.intranet.imscore.core.domain.identity.specification.IdentityListSpecification
import java.time.Instant
import java.util.UUID

/**
 * Identity repository
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
interface IdentityRepository {
    fun findByIdInForUpdate(ids: List<UUID>): List<Identity>
    fun getListBySpec(spec: IdentityListSpecification): List<Identity>
    fun getById(spec: GetIdentityByIdSpecification): Identity
    fun getByIdForUpdate(id: UUID): Identity
    fun findByExternalIdInAndTypeId(externalIds: List<String>, typeId: String): List<Identity>
    fun findByExternalIdInAndTypeIdForUpdate(externalIds: List<String>, typeId: String): List<Identity>
    fun findByExternalIdAndTypeId(externalId: String, typeId: String): Identity?
    fun getByExternalIdAndTypeId(spec: GetIdentityByExternalIdSpecification): Identity
    fun findByExternalIdAndTypeIdForUpdate(externalId: String, typeId: String): Identity?
    fun getByExternalIdAndTypeIdForUpdate(externalId: String, typeId: String): Identity
    fun save(model: Identity): Identity
    fun deleteById(id: UUID): Int
    fun deleteByExternalId(externalId: String, typeId: String): Int
    fun deleteByIdIn(ids: List<UUID>)
    fun findAllIdentitiesByGroupId(spec: IdentityListSpecification): List<Identity>
    fun updateIdentityModifiedAt(ids: List<UUID>, modifiedAt: Instant)
    fun findAllChildrenByIdentityId(spec: IdentityChildListSpecification): List<Identity>
}
