package ru.yandex.intranet.imscore.core.ports.identityRelation


import ru.yandex.intranet.imscore.core.domain.identityRelation.IdentityRelation
import ru.yandex.intranet.imscore.core.domain.identityRelation.specifications.IdentityRelationListSpecification
import java.util.UUID

/**
 * Identity relation repository
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
interface IdentityRelationRepository {
    fun findAllGroupsByIdentityIdAndSpec(
        identityId: UUID, spec: IdentityRelationListSpecification
    ): List<IdentityRelation>
    fun existsIdentityRelationToGroup(
        identityId: UUID, groupId: UUID, connectionType: IdentityRelation.ConnectionType, onlyDirectly: Boolean
    ): Boolean
    fun saveAll(models: List<IdentityRelation>)
    fun deleteByIdentityIdInAndGroupIdAndConnectionType(
        identityIds: List<UUID>, groupId: UUID, connectionType: IdentityRelation.ConnectionType)
    fun deleteByIdentityIdInAndGroupId(identityIds: List<UUID>, groupId: UUID)
    fun save(identityRelation: IdentityRelation): IdentityRelation
    fun upsert(identityRelation: IdentityRelation)
    fun findAllDirectIdentityRelationByGroupId(groupId: UUID): List<IdentityRelation>
}
