package ru.yandex.intranet.imscore.core.ports.identityType

import ru.yandex.intranet.imscore.core.domain.IdentityTypeSource.IdentityTypeSource
import ru.yandex.intranet.imscore.core.domain.identityType.IdentityType
import ru.yandex.intranet.imscore.core.domain.identityType.specifications.IdentityTypeListSpecification

/**
 * IdentityType repository
 *
 * @author Mustakayev Marat <mmarat248@yandex-team.ru>
 */
interface IdentityTypeRepository {
    fun getListBySpec(spec: IdentityTypeListSpecification): List<IdentityType>
    fun save(model: IdentityType, identityTypeSource: IdentityTypeSource): IdentityType
    fun getById(id: String): IdentityType
    fun findById(id: String): IdentityType?
    fun findBySourceId(sourceId: String): List<IdentityType>
}
